﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace ErrorExample
{
    class Turtle
    {
        // Szerokość platformy robota
        public double PlatformWidth
        {
            get;
            set;
        }

        // Wysokość platformy robota
        public double PlatformHeight
        {
            get;
            set;
        }

        // Szybkość, z jaką silniczki kręcą kółkami,
        // wyrażona w metrach na sekundę. Dla ułatwienia zakładamy,
        // że została ona określona na podstawie dystansu, jaki pokonały 
        // kółka robota na powierzchni, po której się porusza
        // (i ewentualnych poślizgów).
        public double MotorSpeed
        {
            get;
            set;
        }

        // Stan lewego silniczka
        public MotorState LeftMotorState
        {
            get;
            set;
        }

        // Stan prawego silniczka
        public MotorState RightMotorState
        {
            get;
            set;
        }

        // Aktualne położenie robota
        public Point CurrentPosition
        {
            get;
            private set;
        }

        // Aktualna orientacja robota
        public double CurrentOrientation
        {
            get;
            private set;
        }


        // Robot się prusza przez zadany okres czasu.
        public void RunFor(double duration)
        {
            if (LeftMotorState == MotorState.Stopped &&
            RightMotorState == MotorState.Stopped)
            {
                // Jeśli robot był całkowicie zatrzymany, nic sie nie stanie.
                return;
            }
            // Jeśli oba silniczki pracowały, kręcąc się w tym samym kierunku,
            // to mogliśmy jechać.
            if ((LeftMotorState == MotorState.Running &&
            RightMotorState == MotorState.Running) ||
            (LeftMotorState == MotorState.Reversed &&
                RightMotorState == MotorState.Reversed))
            {
                Drive(duration);
                return;
            }
            // Silniczki kręcą się w przeciwnych kierunkach,
            // zatem robot nie jedzie do przodu, a jedynie kręci 
            // się wokół swego środka.
            if ((LeftMotorState == MotorState.Running &&
            RightMotorState == MotorState.Reversed) ||
            (LeftMotorState == MotorState.Reversed &&
            RightMotorState == MotorState.Running))
            {
                // Listing 6-7. Wykrywanie błędu i rozważania co z nim można zrobić.
                // Trzaba zauważyć, że ten konkretny przykład nie jest szczególnie 
                // użyteczny - w żaden sposób nie korzystamy ze zwróconego wyniku.
                // Przedstawiliśmy go jedynie po to, by zilustrować problem. 
                // Dopiero w przykładzie 6-8 sensownie wykorzystamy tę informację.
                if (!Rotate(duration))
                {
                    // Nie udało się. Co teraz?
                }
                return;
            }
        }

        // Listing 6-6. Przekazywanie informacji o błędach przy wykorzystaniu wartości zwracanej
        private bool Rotate(double duration)
        {
            if (PlatformWidth <= 0.0)
            {
                return false;
            }
            // Pełna długość okręgu zataczanego przez obracającego się robota
            double circum = Math.PI * PlatformWidth;
            // Całkowity przebyty dystans
            double d = duration * MotorSpeed;
            if (LeftMotorState == MotorState.Reversed)
            {
                // Jeśli silniczki kręcą się w tył, to jedziemy do tyłu.
                d *= -1.0;
            }
            // Stosunek przebytego dystansu do obwodu pełnego obrotu
            double proportionOfWholeCircle = d / circum;
            // Gdy obrót wyniesie 360 stopni (lub 2pi radianów), to przebyta 
            // odległość wyniesie:
            CurrentOrientation =
                CurrentOrientation + (Math.PI * 2.0 * proportionOfWholeCircle);
            return true;
        }


        private void Drive(double duration)
        {
            // Całkowity przejechany dystans
            double d = duration * MotorSpeed;
            if (LeftMotorState == MotorState.Reversed)
            {
                // Jeśli silniczki kręcą się w ty, to jedziemy do tyłu.
                d *= -1.0;
            }
            // Nieco obliczeń trygonometrycznych w celu określenia zmiany
            // współrzędnych x i y
            double deltaX = d * Math.Sin(CurrentOrientation);
            double deltaY = d * Math.Cos(CurrentOrientation);
            // Zaktualizowane położenie robota
            CurrentPosition =
            new Point(CurrentPosition.X + deltaX, CurrentPosition.Y + deltaY);
        }
    }
    // Aktualny stan silniczka
    enum MotorState
    {
        Stopped,
        Running,
        Reversed
    }
}
